import { useState } from "react";
import { useNavigate } from "react-router-dom";
import { signInWithPopup } from "firebase/auth";
import { auth, googleProvider } from "../firebaseConfig";

export default function LoginPage() {
  const [username, setUsername] = useState("");
  const [password, setPassword] = useState("");
  const [error, setError] = useState("");
  const navigate = useNavigate();

  const handleGoogleLogin = async () => {
    try {
      const result = await signInWithPopup(auth, googleProvider);
      const user = result.user;

      localStorage.setItem("isClientAuthenticated", "true");
      localStorage.setItem("clientEmail", user.email);
      localStorage.removeItem("isAdminAuthenticated");

      navigate("/");
    } catch (err) {
      console.error(err);
      setError("Google login failed. Try again.");
    }
  };

  const handleManualLogin = (e) => {
    e.preventDefault();

    // Check admin credentials
    if (username === "admin" && password === "admin123") {
      localStorage.setItem("isAdminAuthenticated", "true");
      localStorage.removeItem("isClientAuthenticated");
      navigate("/admin");
    } else if (username && password) {
      // Normal client login
      localStorage.setItem("isClientAuthenticated", "true");
      localStorage.setItem("clientEmail", username);
      localStorage.removeItem("isAdminAuthenticated");
      navigate("/");
    } else {
      setError("Please enter valid credentials.");
    }
  };

  return (
    <div style={styles.container}>
      <div style={styles.card}>
        <h2 style={styles.title}>Welcome Back</h2>
        <p style={styles.subtitle}>Login</p>

        {error && <p style={styles.error}>{error}</p>}

        <form onSubmit={handleManualLogin} style={styles.form}>
          <input
            type="text"
            placeholder="Username or Email"
            value={username}
            onChange={(e) => setUsername(e.target.value)}
            style={styles.input}
          />
          <input
            type="password"
            placeholder="Password"
            value={password}
            onChange={(e) => setPassword(e.target.value)}
            style={styles.input}
          />
          <button type="submit" style={styles.button}>
            Login
          </button>
        </form>

        <div style={styles.divider}>
          <span>or</span>
        </div>

        <button onClick={handleGoogleLogin} style={styles.googleButton}>
          <img
            src="https://developers.google.com/identity/images/g-logo.png"
            alt="Google"
            style={{ width: "20px", marginRight: "10px" }}
          />
          Continue with Google
        </button>
      </div>
    </div>
  );
}

const styles = {
  container: {
    minHeight: "100vh",
    display: "flex",
    justifyContent: "center",
    alignItems: "center",
    background: "#f3f4f6",
  },
  card: {
    background: "#fff",
    padding: "2.5rem",
    borderRadius: "10px",
    boxShadow: "0 4px 12px rgba(0,0,0,0.1)",
    width: "360px",
    textAlign: "center",
  },
  title: {
    fontSize: "1.8rem",
    marginBottom: "0.3rem",
    color: "#111827",
  },
  subtitle: {
    fontSize: "0.95rem",
    color: "#6b7280",
    marginBottom: "1.5rem",
  },
  error: {
    color: "red",
    marginBottom: "1rem",
  },
  form: {
    display: "flex",
    flexDirection: "column",
    gap: "0.8rem",
  },
  input: {
    padding: "10px",
    borderRadius: "6px",
    border: "1px solid #ccc",
    fontSize: "1rem",
  },
  button: {
    backgroundColor: "#2e7d32",
    color: "white",
    border: "none",
    padding: "10px",
    borderRadius: "6px",
    cursor: "pointer",
    fontSize: "1rem",
  },
  googleButton: {
    marginTop: "1rem",
    display: "flex",
    alignItems: "center",
    justifyContent: "center",
    background: "white",
    border: "1px solid #ccc",
    borderRadius: "6px",
    padding: "10px",
    cursor: "pointer",
    width: "100%",
  },
  divider: {
    margin: "1.5rem 0",
    fontSize: "0.9rem",
    color: "#888",
  },
};
