'use client';

import { useState } from 'react';

export default function Contact() {
  const [isSubmitting, setIsSubmitting] = useState(false);
  const [submitSuccess, setSubmitSuccess] = useState(false);

  const handleSubmit = (e) => {
    e.preventDefault();
    setIsSubmitting(true);

    // Simulate form submission delay (e.g., saving to admin panel)
    setTimeout(() => {
      setSubmitSuccess(true);
      setIsSubmitting(false);
      e.target.reset();
    }, 600);
  };

  // Inline styles
  const containerStyle = {
    maxWidth: '800px',
    margin: '0 auto',
    padding: '2rem',
    fontFamily: "'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif",
  };

  const headerStyle = {
    fontSize: '2.25rem',
    fontWeight: '700',
    textAlign: 'center',
    marginBottom: '2rem',
    color: '#1e293b',
  };

  const cardStyle = {
    backgroundColor: '#ffffff',
    borderRadius: '16px',
    boxShadow: '0 10px 30px rgba(0, 0, 0, 0.08)',
    padding: '2.5rem',
    display: 'flex',
    gap: '2.5rem',
    flexWrap: 'wrap',
  };

  const formStyle = {
    flex: '1',
    minWidth: '300px',
  };

  const infoStyle = {
    flex: '1',
    minWidth: '250px',
    display: 'flex',
    flexDirection: 'column',
    justifyContent: 'center',
  };

  const infoTitleStyle = {
    fontSize: '1.35rem',
    fontWeight: '700',
    marginBottom: '1.5rem',
    color: '#4f46e5',
  };

  const infoItemStyle = {
    display: 'flex',
    alignItems: 'flex-start',
    marginBottom: '1.25rem',
  };

  const iconStyle = {
    marginRight: '0.85rem',
    fontSize: '1.35rem',
    color: '#64748b',
    marginTop: '4px',
  };

  const labelStyle = {
    display: 'block',
    marginBottom: '0.6rem',
    fontWeight: '600',
    color: '#334155',
    fontSize: '0.95rem',
  };

  const inputStyle = {
    width: '100%',
    padding: '0.85rem',
    borderRadius: '10px',
    border: '1px solid #e2e8f0',
    fontSize: '1rem',
    backgroundColor: '#f8fafc',
    transition: 'border-color 0.2s, box-shadow 0.2s',
  };

  const textareaStyle = {
    ...inputStyle,
    minHeight: '130px',
    resize: 'vertical',
  };

  const buttonStyle = {
    backgroundColor: '#4f46e5',
    color: 'white',
    border: 'none',
    padding: '0.85rem 1.75rem',
    borderRadius: '10px',
    fontSize: '1rem',
    fontWeight: '600',
    cursor: 'pointer',
    marginTop: '0.75rem',
    transition: 'background-color 0.2s, transform 0.2s',
  };

  return (
    <div style={containerStyle}>
      <h1 style={headerStyle}>Contact Velvera</h1>

      <div style={cardStyle}>
        {/* Contact Form */}
        <div style={formStyle}>
          <form onSubmit={handleSubmit}>
            <div style={{ marginBottom: '1.5rem' }}>
              <label style={labelStyle}>Your Name</label>
              <input type="text" name="name" style={inputStyle} required />
            </div>
            <div style={{ marginBottom: '1.5rem' }}>
              <label style={labelStyle}>Email Address</label>
              <input type="email" name="email" style={inputStyle} required />
            </div>
            <div style={{ marginBottom: '1.5rem' }}>
              <label style={labelStyle}>Message</label>
              <textarea name="message" style={textareaStyle} required></textarea>
            </div>

            {submitSuccess && (
              <div style={{ color: '#10b981', marginBottom: '1rem', fontSize: '0.9rem' }}>
                Thank you! Your message has been received by our admin team.
              </div>
            )}

            <button
              type="submit"
              style={{
                ...buttonStyle,
                opacity: isSubmitting ? 0.8 : 1,
                cursor: isSubmitting ? 'not-allowed' : 'pointer',
              }}
              disabled={isSubmitting}
            >
              {isSubmitting ? 'Sending...' : 'Send Message'}
            </button>
          </form>
        </div>

        {/* Contact Info */}
        <div style={infoStyle}>
          <h2 style={infoTitleStyle}>Get in Touch</h2>
          <div style={infoItemStyle}>
            <span style={iconStyle}>📧</span>
            <div>
              <div style={{ fontWeight: '600', color: '#1e293b', fontSize: '1rem' }}>Email</div>
              <div style={{ color: '#475569' }}>velveraluxe1@gmail.com</div>
            </div>
          </div>
          <div style={infoItemStyle}>
            <span style={iconStyle}>📱</span>
            <div>
              <div style={{ fontWeight: '600', color: '#1e293b', fontSize: '1rem' }}>Phone</div>
              <div style={{ color: '#475569' }}>+92 339 5936453</div>
            </div>
          </div>
          <div style={infoItemStyle}>
            <span style={iconStyle}>💬</span>
            <div>
              <div style={{ fontWeight: '600', color: '#1e293b', fontSize: '1rem' }}>WhatsApp</div>
              <a
                href="https://wa.me/923395936453"
                target="_blank"
                rel="noopener noreferrer"
                style={{ color: '#4f46e5', textDecoration: 'none' }}
              >
                Chat on WhatsApp
              </a>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
}