import { useState, useContext } from 'react';
import axios from 'axios';
import { CartContext } from '../context/CartContext';

export default function Checkout() {
  const { cart, getCartTotal } = useContext(CartContext);
  const [file, setFile] = useState(null);
  const [message, setMessage] = useState('');

  const handleSubmit = async (e) => {
    e.preventDefault();
    if (!file) {
      alert('Please upload payment screenshot');
      return;
    }

    const formData = new FormData();
    formData.append('paymentScreenshot', file);
    formData.append('userId', 'user123'); // In real app, use auth
    formData.append('products', JSON.stringify(cart.map(p => ({ productId: p._id, quantity: p.quantity }))));

    try {
      await axios.post('/api/orders', formData, {
        headers: { 'Content-Type': 'multipart/form-data' }
      });
      setMessage('✅ Order submitted! Admin will verify your payment.');
    } catch (err) {
      setMessage('❌ Failed to submit order. Please try again.');
    }
  };

  if (cart.length === 0) {
    return (
      <div className="container" style={{ textAlign: 'center', marginTop: '50px' }}>
        <h2>Your cart is empty</h2>
        <a href="/" className="btn btn-primary" style={{ display: 'inline-block', marginTop: '20px' }}>Shop Now</a>
      </div>
    );
  }

  return (
    <div className="container">
      <h2 style={{ textAlign: 'center', marginBottom: '20px' }}>Checkout</h2>
      <div className="card">
        <h3>Order Summary</h3>
        {cart.map(item => (
          <p key={item._id}>{item.name} × {item.quantity} = ${(item.price * item.quantity).toFixed(2)}</p>
        ))}
        <h4>Total: ${getCartTotal().toFixed(2)}</h4>

        <form onSubmit={handleSubmit} style={{ marginTop: '20px' }}>
          <div className="form-group">
            <label>Upload Payment Screenshot</label>
            <input
              type="file"
              accept="image/*"
              onChange={(e) => setFile(e.target.files[0])}
              required
            />
          </div>
          <button type="submit" className="btn btn-success">Submit Payment Proof</button>
          {message && <p style={{ marginTop: '10px', color: message.includes('✅') ? 'green' : 'red' }}>{message}</p>}
        </form>
      </div>
    </div>
  );
}