// components/ImageCarousel.jsx
'use client';

import { useEffect, useRef } from 'react';
import './ImageCarousel.css';

const ImageCarousel = () => {
  const containerRef = useRef(null);

  // ✅ Use real placeholder images for testing
  const images = [
    'https://via.placeholder.com/1920x1080/4e008c/ffffff?text=VULVERA+1',
    'https://via.placeholder.com/1920x1080/7b00d3/ffffff?text=VULVERA+2',
    'https://via.placeholder.com/1920x1080/3a007a/ffffff?text=VULVERA+3',
    'https://via.placeholder.com/1920x1080/6e00c2/ffffff?text=VULVERA+4',
    'https://via.placeholder.com/1920x1080/4e008c/ffffff?text=VULVERA+5',
  ];

  useEffect(() => {
    const container = containerRef.current;
    if (!container) return;

    let currentIndex = 0;
    let isScrolling = false;

    const handleWheel = (e) => {
      if (isScrolling) return;
      isScrolling = true;

      if (e.deltaY > 0) {
        currentIndex = (currentIndex + 1) % images.length;
      } else {
        currentIndex = (currentIndex - 1 + images.length) % images.length;
      }

      container.scrollTo({
        top: currentIndex * window.innerHeight,
        behavior: 'smooth',
      });

      setTimeout(() => {
        isScrolling = false;
      }, 1000);
    };

    container.addEventListener('wheel', handleWheel, { passive: false });

    return () => {
      container.removeEventListener('wheel', handleWheel);
    };
  }, [images]);

  return (
    <div className="image-carousel" ref={containerRef}>
      {images.map((img, index) => (
        <div key={index} className="carousel-slide">
          <div className="slide-content">
            {/* ✅ Fallback background if image fails */}
            <div
              className="slide-image"
              style={{
                backgroundImage: `url(${img})`,
                backgroundSize: 'cover',
                backgroundPosition: 'center',
                filter: 'brightness(0.7)',
              }}
            ></div>
            <div className="slide-overlay">
              <h2>VULVERA</h2>
              <p>Start Ordering</p>
              <button className="live-now-btn">Live Now</button>
            </div>
          </div>
        </div>
      ))}
    </div>
  );
};

export default ImageCarousel;