// components/GoogleLoginButton.jsx
import { useEffect } from 'react';

export default function GoogleLoginButton({ onSuccess, onError }) {
  useEffect(() => {
    if (window.google && window.google.accounts) {
      window.google.accounts.id.initialize({
        client_id: "YOUR_GOOGLE_CLIENT_ID.apps.googleusercontent.com", // 👈 REPLACE THIS
        callback: handleCredentialResponse,
        auto_select: false,
        cancel_on_tap_outside: true,
      });

      window.google.accounts.id.renderButton(
        document.getElementById("google-button"),
        { theme: "outline", size: "large" }
      );
    }
  }, []);

  const handleCredentialResponse = (response) => {
    try {
      // Decode JWT token to get user info
      const decoded = parseJwt(response.credential);
      onSuccess(decoded); // Pass user data to parent
    } catch (err) {
      onError?.("Failed to decode Google token");
    }
  };

  const parseJwt = (token) => {
    try {
      return JSON.parse(atob(token.split(".")[1]));
    } catch (e) {
      return null;
    }
  };

  return (
    <div id="google-button" className="google-login-button"></div>
  );
}