export default function Footer() {
  const currentYear = new Date().getFullYear();

  const footerStyle = {
    backgroundColor: '#1e1e1e',
    color: '#e5e7eb', // gray-300
    padding: '2rem 2rem',
    textAlign: 'center',
    fontFamily: "'Segoe UI', Tahoma, Geneva, Verdana, sans-serif",
    fontSize: '0.95rem',
    borderTop: '1px solid #374151', // subtle top border
    marginTop: 'auto', // pushes footer to bottom if used with flex layout
  };

  const brandStyle = {
    fontWeight: '700',
    color: '#818cf8', // indigo-400 — matches Velvera's brand from navbar
    letterSpacing: '0.5px',
  };

  const linkStyle = {
    color: '#a5b4fc', // indigo-300
    textDecoration: 'none',
    fontWeight: '500',
    transition: 'color 0.2s ease',
  };

  return (
    <footer style={footerStyle}>
      <p>
        © {currentYear}{' '}
        <span style={brandStyle}>Velvera</span>. All rights reserved.{' '}
        <a
          href="/privacy"
          style={linkStyle}
          onMouseEnter={(e) => (e.target.style.color = '#c7d2fe')}
          onMouseLeave={(e) => (e.target.style.color = '#a5b4fc')}
        >
          Privacy Policy
        </a>{' '}
        •{' '}
        <a
          href="/terms"
          style={linkStyle}
          onMouseEnter={(e) => (e.target.style.color = '#c7d2fe')}
          onMouseLeave={(e) => (e.target.style.color = '#a5b4fc')}
        >
          Terms of Service
        </a>
      </p>
    </footer>
  );
}